/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import net.skinsrestorer.shadow.mariadb.client.Column;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;
import net.skinsrestorer.shadow.mariadb.type.Geometry;
import net.skinsrestorer.shadow.mariadb.type.LineString;
import net.skinsrestorer.shadow.mariadb.type.Point;

public class LineStringCodec
implements Codec<LineString> {
    public static final LineStringCodec INSTANCE = new LineStringCodec();

    @Override
    public String className() {
        return LineString.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(LineString.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LineString;
    }

    @Override
    public LineString decodeText(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal);
    }

    @Override
    public LineString decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length - 4, column);
            if (geo instanceof LineString) {
                return (LineString)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as LineString", geo.getClass().getName()));
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as LineString", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_LineFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        LineString line = (LineString)value;
        encoder.writeLength(13L + (long)line.getPoints().length * 16L);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(2);
        encoder.writeInt(line.getPoints().length);
        for (Point pt : line.getPoints()) {
            encoder.writeDouble(pt.getX());
            encoder.writeDouble(pt.getY());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

